\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 16))
  %markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Priceasnă la Înviere şi Înălţare"
  composer = \markup \center-column { " " \small " " \small " " } 
  meter = "Andantino"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  \time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
}

sopStanzaOne = \lyricmode {
  \set stanza = "1."
  Din mor -- mân -- tu-n -- tu -- ne -- cat __ Azi Hris -- tos a în -- vi -- at, __
  a-n -- vi -- at, __ a-n -- vi -- at, __  Via -- ţă veş -- ni -- că ne-a dat, __
  A-n -- vi- că ne-a dat.
}

menStanzaOne = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  a-n -- vi -- at, a-n -- vi -- at,  Via -- ţă veş -- ni -- că ne-a dat, __
  că ne-a dat.
}

sopStanzaTwo = \lyricmode {
  \set stanza = "2."
  În -- ge -- rii în ce -- ruri sus, __ Cân -- tă Sla -- va Lui Ii -- sus, __ Lui Ii --
  sus, __ Lui Ii -- sus, __ Că vi -- a -- ţa ne-a a -- dus, __ Lui Ii- 
  ne-a a -- dus.
}

menStanzaTwo = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  lui Ii -- sus, lui Ii -- sus, Că vi -- a -- ţa
   ne-a a -- dus, __ ne-a a -- dus.
}

sopStanzaThree = \lyricmode {
  \set stanza = "3."
  Pă -- să -- ri -- le ci -- ri -- pesc, __ Toa -- te flo -- ri -- le-n -- 
  flo -- resc, __ În -- flo -- resc, __ în -- flo -- resc, __ Paş -- ti -- le săr -- bă --
  to -- resc, __ În -- flo- bă -- to -- resc.
}

menStanzaThree = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  în -- flo -- resc, în -- flo -- resc, Paş -- ti -- le săr -- bă --
  to -- resc, __ bă -- to -- resc.
}

sopStanzaFour = \lyricmode {
  \set stanza = "4."
  Ia -- ră noi, în lu -- me jos, __ Cân -- tăm Sla -- vă Lui Hris -- tos, __ Lui Hris 
  -- tos, __ Lui Hris -- tos, __ Ca -- re din pă -- mânt ne-a scos, __ Lui Hris-
  mânt ne-a scos.
}

menStanzaFour = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  lui Hris -- tos, lui Hris -- tos, Ca -- re din pă -- mânt ne-a scos, __
  mânt ne-a scos.
}

sopStanzaFive = \lyricmode {
  \set stanza = "5."
  Să cân -- tăm a -- de -- vă -- rat, __ Azi Hris -- tos a în -- vi -- at, __
  a-n -- vi -- at, __ a-n -- vi -- at, __  Via -- ţă veş -- ni -- că ne-a dat, __
  A-n -- vi- că ne-a dat.
}

menStanzaFive = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  a-n -- vi -- at, a-n -- vi -- at,  Via -- ţă veş -- ni -- că ne-a dat, __
  că ne-a dat.
}

sopMusic = \relative c' {
  c8 c
  a'4 f 
  \tuplet 3/2 { g8( f8) e8 } f4( f) 
  f8 a c4 a
  \tuplet 3/2 { b8( a) g } a4( a)
  f8 f
  \repeat volta 2 {
   d'2( d4) b8 d c2( c4) b8 a g4 a
  }
  \alternative {
   { \tuplet 3/2 { b8( a) g } c4( c) f,8 f }
   { \tuplet 3/2 { b8( a) g } f4 b4\rest }
  }
  \bar "|."
}

altMusic = \relative c' {
  c8 c f4 f \tuplet 3/2 { e8( f8) c8 } c4( c)
  f8 f a4 f \tuplet 3/2 { e8( f8) e8 } f4( f) f8 f 
  \repeat volta 2 {
   b2( b4) f8 b a2( a4) g8 f e4 f
  }
  \alternative {
   { \tuplet 3/2 { g8( f) e } a4( a) f8 f }
   { \tuplet 3/2 { g8( f) e } f4 b4\rest }
  }
}

tenorMusic = \relative c {
  c8 c a'4 c \tuplet 3/2 { b8( a) g } a4( a)
  a8 c c4 c \tuplet 3/2 { c4 c8 } a4( a) d,4\rest
  \repeat volta 2 {
   d4\rest b'8 a g4 d4\rest d4\rest a'8 b c4
   c8 c c4 c
  }
  \alternative {
   { \tuplet 3/2 { c4 c8 } c4( c) d,4\rest }
   { \tuplet 3/2 { c'4 b8 } a4 d,4\rest }
  }
}  

bassMusic = \relative {
  c8 c f4 f \tuplet 3/2 { c4 c8 } f4( f) 
  f8 f a4 f \tuplet 3/2 { g8( f) e } f4( f) d4\rest
  \repeat volta 2 {
   d4\rest b'8 a g4 d4\rest d4\rest a'8 g f4 f8 f c4 c
  }
  \alternative {
    { \tuplet 3/2 { c4 c8 } f4( f) d4\rest }
    { \tuplet 3/2 { c4 c8 } <f f,>4 d4\rest }
   }
}
   
myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\set Staff.instrumentName = #"S"
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \sopStanzaOne }
      \addlyrics { \sopStanzaTwo }
      \addlyrics { \sopStanzaThree }
      \addlyrics { \sopStanzaFour }
      \addlyrics { \sopStanzaFive }
      \new Voice { \voiceTwo \global \altMusic }
     >>
   \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \addlyrics { \menStanzaOne }
      \addlyrics { \menStanzaTwo }
      \addlyrics { \menStanzaThree }
      \addlyrics { \menStanzaFour }
      \addlyrics { \menStanzaFive }
      \new Voice { \voiceTwo \global \bassMusic }
     
    >>
   >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
